/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.client.gui.handler;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.satisfy.farm_and_charm.client.gui.handler.AbstractRecipeBookGUIScreenHandler;
import net.satisfy.farm_and_charm.client.gui.handler.slot.ExtendedSlot;
import net.satisfy.farm_and_charm.core.block.entity.CookingPotBlockEntity;
import net.satisfy.farm_and_charm.core.recipe.CookingPotRecipe;
import net.satisfy.farm_and_charm.core.registry.ScreenhandlerTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.TagRegistry;

public class CookingPotGuiHandler
extends AbstractRecipeBookGUIScreenHandler {
    private final ContainerData propertyDelegate;

    public CookingPotGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(8), (ContainerData)new SimpleContainerData(2));
    }

    public CookingPotGuiHandler(int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super((MenuType)ScreenhandlerTypeRegistry.COOKING_POT_SCREEN_HANDLER.get(), syncId, 7, playerInventory, inventory, propertyDelegate);
        this.buildBlockEntityContainer(inventory);
        this.buildPlayerContainer(playerInventory);
        this.propertyDelegate = propertyDelegate;
        this.m_38884_(propertyDelegate);
    }

    private void buildBlockEntityContainer(Container inventory) {
        this.m_38897_(new ExtendedSlot(inventory, 6, 95, 55, stack -> stack.m_204117_(TagRegistry.CONTAINER)));
        for (int row = 0; row < 2; ++row) {
            for (int slot = 0; slot < 3; ++slot) {
                this.m_38897_(new Slot(inventory, slot + row * 3, 30 + slot * 18, 17 + row * 18));
            }
        }
        this.m_38897_(new Slot(inventory, 7, 124, 28){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
    }

    private void buildPlayerContainer(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    public boolean isBeingBurned() {
        return this.propertyDelegate.m_6413_(1) != 0;
    }

    public int getScaledProgress(int arrowWidth) {
        int progress = this.propertyDelegate.m_6413_(0);
        int totalProgress = CookingPotBlockEntity.getMaxCookingTime();
        if (progress == 0) {
            return 0;
        }
        return progress * arrowWidth / totalProgress + 1;
    }

    @Override
    public boolean hasIngredient(Recipe<?> recipe) {
        if (recipe instanceof CookingPotRecipe) {
            CookingPotRecipe cookingPotRecipe = (CookingPotRecipe)recipe;
            for (Ingredient ingredient : cookingPotRecipe.m_7527_()) {
                boolean found = false;
                for (Slot slot : this.f_38839_) {
                    if (!ingredient.test(slot.m_7993_())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            if (cookingPotRecipe.isContainerRequired()) {
                ItemStack requiredContainer = cookingPotRecipe.getContainerItem();
                boolean containerFound = false;
                for (Slot slot : this.f_38839_) {
                    if (requiredContainer.m_41720_() != slot.m_7993_().m_41720_()) continue;
                    containerFound = true;
                    break;
                }
                return containerFound;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getCraftingSlotCount() {
        return 7;
    }
}

